; Key Sequencer Alpha 1.8
; m65v50 (c) benj9 


; entry m65v50
; 114C9D4: 041C251C B3F694FB ; -> A1000100
; repatch: ADD R4, R0, #0. ADD R5, R4, #0


			AREA benj9, CODE, READONLY              
			ENTRY
			; GBLA	FIRMWARE	; defined in project/target

; FIRMWARE	SETA	1 ; $FW_target 	; 1=m65v50, 2=sl65v50, 3=m75v13				


; constants
number_of_sequence_records	EQU	18
hotkey						EQU	"*" ; 



sp_add_scan_key_sequences	EQU	0x1C ; sp offset for sub "scan_key_sequences"

sp_no_of_slots				EQU	0x18 ; number of additional parameters needed
sp_ActionPerformed			EQU 0    ; [SP,#0] ; SequAccepted&ActionPerformed(FF=False)
sp_State_keylock			EQU 4     ; keylock state
sp_ScanKeySequencesMode		EQU 8  ; [SP,#0xC] ; scan_key_sequences - mode. 0=direct mode. 1=after hotkey mode.
sp_Direct_or_Hotkey_seq		EQU	0xC
sp_State_screensaver		EQU 0x10  ; screensaver state
sp_State_screensaver_addr	EQU 0x14  ; address of screensaver state


; not cleared  by _clear_mem:
ram_mp_pointer								EQU 0
ram_timer_data								EQU	4
ram_unused									EQU	13
ram_SequenceRecords							EQU	15 

;  cleared often by _clear_mem:
ram_ram_clear_please						EQU 16 ; section label
ram_IsTimeoutTimerRunning					EQU	16
ram_keypress_after_hotkey_counter			EQU 17 ; [ram_basement+1] keypress-after-hotkey-counter
ram_IsAnythingTouched						EQU 18 ; [SP,#0x10] ; is in ScanKeySequences the key in at least one sequence?
ram_hotkey_trigger							EQU	19
ram_sequence_record_table					EQU	20 ; ; [ram_basement+3]... sequence record buffers 


; one record has 16 bytes. 
; 0  1  2  3   4  5  6  7  8 9 A B C  D  E  F
; action       R0 R0 PP EE KKKKKKKKKK CC SS LL
seq_address									EQU	0
seq_r0										EQU	4
seq_action_type								EQU	6
seq_exec_bits								EQU	7
seq_keys									EQU 8
seq_condition_bits							EQU 13
seq_sound									EQU	14
seq_soundlen								EQU	15


mp_ram_char_hotkey							EQU	2
mp_ram_char_escape							EQU	3
mp_ram_timeout_time							EQU	4
mp_ram_sound_hotkey_activate				EQU	8
mp_ram_soundlen_hotkey_activate				EQU	9
mp_ram_sound_hotkey_seq_failed				EQU	10
mp_ram_soundlen_hotkey_seq_failed			EQU	11
mp_ram_keysequences							EQU	16	


FF					EQU 0xFF

 
; ram_basemen+2: count_key_in_sequence[0], ..., count_key_in_sequence[n-1]
; count_key_in_sequence=0: not entered. =n: n keys accepted.

; -----------------------------------------------------------------------------

 CODE16			
 
						IMPORT	sequences
						IMPORT keyseq_strings
 						EXPORT main		
 
 						IMPORT	mp_Bufferizer				
 
						IMPORT	f003_SetProfile
						IMPORT	f008_SetIllumination
						IMPORT	f009_SwitchPhoneOff
						
						IMPORT	f022_sPrintf
						
						IMPORT	f031_DrawMainScreen
						IMPORT	f020_malloc
						IMPORT	f038_DrawImageBW

						IMPORT	f052_PlaySoundLoop
						
						IMPORT	f066_IsScreenSaver
						IMPORT	f067_IsUnlocked
						IMPORT	f068_TempLightOn
						
						IMPORT	f074_PlayFile
						IMPORT	f075_StartMidlet
						IMPORT	f077_CallAfterTimer
						IMPORT	f081_GetNetMode
						
						IMPORT	f088_ClearMemory 
						
						IMPORT	f100_EndUpdateScreen
						
						IMPORT	f104_Screensaver_GetAddress
						IMPORT	f105_LockSched
						IMPORT	f106_UnLockSched
						
						IMPORT	f192_MiniGPS
					
						IMPORT	v13_RamIsLocked
						IMPORT	v14_RamNetOnline
 
						IMPORT	z00_FreeRAM
; -----------------------------------------------------------------------------

					DCB		"KeySq18,benj9",0
					
; -----------------------------------------------------------------------------

; key_on_events and key_off_events(key=key_on+0x80)
		
main				PUSH	{R0-R7,LR}  ; ???

					SUB		SP,#sp_no_of_slots ; need more stack slots
					MOV		R5,R0 ; save R5 = key number

					; ---------------------------------------------------------
					
					LDR		R6,ram_mainscreen_accu_icon_
					LDRH	R6,[R6]
					CMP		R6,#0 ; phone boots up?
					BEQ		m_nopatch
					
					LDR		R0,_ram_is_shutdown
					LDRB	R0,[R0]
					CMP		R0,#1
					BEQ		m_nopatch
					
					LDR		R4,patch_ram
					LDR		R4,[R4]
					CMP		R4,#1
					BEQ		m_nopatch
										
					BL		z00_FreeRAM ; get masterpatch base pointer
					LDR		R7,[R7]
					ADD		R7,#1
					BPL		m_nopatch ; masterpatch is not working
					
					LDR		R0,mp_id
					BL		mp_Bufferizer ; r0=r6=get masterpatch buffer pointer
					BEQ		m_nopatch
					
					CMP		R4,#0
					BPL		m_init_count_seq
					
					STR		R6,[R4,#ram_mp_pointer]
					B		m_on_off
							
m_init_count_seq	ADD		R0,#mp_ram_keysequences
					MOV		R4,#0 ; is my malloc ram already initialized?
					LDR		R2,end_of_sequences_magic
					
m_init_count_seq_l	LDR		R3,[R0]
					CMP		R3,R2 ; end of sequences?
					BEQ		m_init_ram
					
					CMP		R4,#64 ; max num of key sequences to protect if no magic word
					BLT		m_init_count_seq_l1
					
					; ADR		R0,_err_noseqendtoken
					B		m_init_ram_lock	
					
m_init_count_seq_l1	ADD		R0,#16
					ADD		R4,#1
					B		m_init_count_seq_l	

m_init_ram			MOV		R0,R4 ; number of sequences found
					BNE		m_init_ram_malloc
					
					; ADR		R0,_err_noseq
					B		m_init_ram_lock ; no sequences found (strange thing)
			
m_init_ram_malloc	ADD		R0,#ram_sequence_record_table
					BL		f020_malloc ; get my malloc ram pointer
					MOV		R7,R4
					MOV		R4,R0
					BNE		m_init_ram_1
					
					; ADR		R0,_err_nomem
									
m_init_ram_lock		; BL		_error_message
					LDR		R1,patch_ram
					MOV		R0,#1
					STR		R0,[R1] ; lock

m_nopatch			MOV		R0,R5
					LSL     R1,R0,#0x18 ; key_off=key_on+0x80
					BMI     m_off_exec ; is negative?
					B		m_on_exec
					
m_init_ram_1		LDR		R1,patch_ram
					STR		R4,[R1] ; malloc pointer to base pointer
					STR		R6,[R4,#ram_mp_pointer] ; mp buffer ptr 
					STRB	R7,[R4,#ram_SequenceRecords]
																		
m_init_ram_reset	BL		_clear_mem			
					BL		_sound_init_ok
					
					
					
					; ---------------------------------------------------------
					
					

m_on_off	 		LSL     R0,R5,#0x18 ; key_off=key_on+0x80
					BMI     m_off ; is negative?

m_on				BL		_get_scrsaver
					STR		R0,[SP,#sp_State_screensaver]
					
					BL		v13_RamIsLocked 
					LDRB	R0,[R7]
					STR		R0,[SP,#sp_State_keylock]
					
					MOV		R0,R5 ; put R0 = pressed key
					LDRB	R2,[R4,#ram_hotkey_trigger] ; hotkey enabled flag

					CMP		R0,#hotkey ; ###hotkey###
					BNE		m_on_hotk_no
					
m_on_hotkey			CMP		R2,#1 ; is hotkey already enabled?
					BGE		m_on_escape_all ; hotkey already enabled
					
m_on_hotk_activate	MOV		R2,#2 ; lock hotkey trigger
					STRB	R2,[R4,#ram_hotkey_trigger] ; enable hotkey flag
					STRB	R2,[R4,#ram_IsAnythingTouched] ; set ram_IsAnythingTouched to true		
					MOV		R2,#0 ; zero keypresses-after-hotkey-counter
					STRB	R2,[R4,#ram_keypress_after_hotkey_counter] 

					BL		_sound_hotk_activ
					BL		_start_seq_timeout_timer
					B		main_exit
					
m_on_hotk_no		CMP		R0,#0xC ; red button
					BEQ		m_on_redkey ; kill sequence buffers and hotkey on red button when sequence is running
			
					CMP		R2,#0 
					BNE		m_on_hotk_snapped_y ; isnt hotkey already enabled?

m_on_hotk_snapped_n	MOV		R1,#0 ; direct mode
					STR		R1,[SP,#sp_ScanKeySequencesMode]  ; without hotkey, direct mode.
					BL 		scan_key_sequences
					CMP		R1,#FF ; SequAccepted&ActionPerformed(FF=False)
					BEQ		m_on_exec
					
					BL		_clear_mem
					B		m_on_exec 	
					
m_on_hotk_snapped_y	MOV		R1,#1
					STR		R1,[SP,#sp_ScanKeySequencesMode]  ; "after hotkey" mode
					BL 		scan_key_sequences
					
					; ----------------------------------------------------------------------
					; code after scan_key_sequences or no sequences are scanned
					
					LDRB	R2,[R4,#ram_keypress_after_hotkey_counter] ; [ram_basement+1] keypress-after-hotkey-counter
					ADD		R2,#1
					STRB	R2,[R4,#ram_keypress_after_hotkey_counter] ; increase the counter 

					LDRB	R2,[R4,#ram_IsAnythingTouched]
					CMP		R2,#1
					BEQ		m_on_hotk_touched_y

					BL		_sound_key_failed
					B		m_on_hotk_touched_n
					
m_on_hotk_touched_y	CMP		R1,#FF ; SequAccepted&ActionPerformed(FF=False)
					BEQ		main_exit 
					
					BL		_clear_mem
					
m_on_hotk_touched_n	MOV		R2,#1 ; hotkeyflag: skip key_off, but be 0 on next key.
					STRB	R2,[R4,#ram_hotkey_trigger] ; enable hotkey flag
					B		main_exit
					
m_on_redkey			LDRB	R1,[R4,#ram_IsAnythingTouched]
					CMP		R1,#0
					BEQ		m_on_exec
					
					CMP		R2,#0 ; is not hotkey  enabled
					BEQ		m_on_escape_all_1

m_on_escape_all		BL		_sound_key_failed

m_on_escape_all_1	BL		_clear_mem
					MOV		R1,#0 ; disable hotkey flag
					STRB	R1,[R4,#ram_hotkey_trigger]
					B		m_on_exec					
		
m_on_exec			LDR		R1,Keypress_On_Store2Ram_
					B		m_exec
				
m_off				LDR		R0,FF00
					CMP		R6,R0 ; mainscreen-status off because key seq called a func?
					BNE		m_off_1

					MOV		R0,#3 ; turn all lights on
					BL		f068_TempLightOn ; if command launched

m_off_1				MOV		R0,R5
					LDRB	R2,[R4,#ram_hotkey_trigger] ; hotkey enabled flag

					CMP		R2,#0 ; 0: no hotkey flag. 
					BEQ		m_off_exec
					
					CMP		R2,#1 ; 1: hotkeyflag for key_off locked, after clear. 2: hotkey flag locked, leave
					BNE		main_exit
					
					MOV		R2,#0 ; disable hotkey flag
					STRB	R2,[R4,#ram_hotkey_trigger] ;  hotkey flag
					B		main_exit	

m_off_exec			LDR		R1,Keypress_Off_Store2Ram_

m_exec				BLX		R1

main_exit			ADD		SP,#sp_no_of_slots ; release my stack slot
					POP		{R0-R7,PC}
					


; -----------------------------------------------------------------------------	
					
_sound_hotk_activ	PUSH	{R0-R3,LR}
					MOV		R0,#0x78
					MOV		R2,#1
					B		_sound_x

_sound_key_failed	PUSH	{R0-R3,LR}
					MOV		R0,#0x7B
					MOV		R2,#1
					B		_sound_x
					
_sound_init_ok		PUSH	{R0-R3,LR}
					MOV		R0,#0x2F ; vibrate
					MOV		R2,#1
					
_sound_x			BL		_playsoundloop
					POP		{R0-R3,PC}
				
; ========================================================================================

scan_key_sequences
				PUSH	{R0,R2-R4,R6-R7,LR}

s_init			MOV		R7,#0 ; counter of sequences
				STRB	R7,[R4,#ram_IsAnythingTouched] ; set to false	
				
				; ADD		R4,#ram_sequence_record_table ; goto base address for sequence record table

				; ----------------------------------------------------------------------
				
s_loop			LDR		R3,_sequences
				; LDR		R
				
				; SUB		R0,R4,#(ram_sequence_record_table - ram_SequenceRecords)
				
				LDRB	R0,[R4,#ram_SequenceRecords] ; R0=# of sequence records
				CMP		R0,R7
				BLE		s_exit ; if last sequence+1, its so nice, but i must leave

				MOV		R0,#ram_sequence_record_table
				ADD		R0,R4
				LDRB	R1,[R0,R7] ; ram status byte of current sequence

				LSL		R6,R7,#4 ; *16
				ADD		R2,R3,R6 ; address of very first byte of current sequence record
								
				LDRB	R0,[R2,#seq_action_type] ; Sequence action type (0=sequence disengaged)
				CMP		R0,#0
				BEQ		s_key_not_valid
				
				MOV		R0,#FF
				STR		R0,[SP,#sp_add_scan_key_sequences+ sp_ActionPerformed] ; SequAccepted&ActionPerformed(FF=False) [SP] reset with FF
				
				; --- filter ----------------------------------------------------------------
				; process sequence record depending SequenceMode_Snap _AfterHotkey or _Directly?
				
				LDR		R6,[SP,#sp_add_scan_key_sequences+ sp_ScanKeySequencesMode]
				LDRB	R3,[R2,#seq_exec_bits] ; execution bits of sequence record
				MOV		R0,#1 ; bit 0
				AND		R0,R3 ; sequence mode byte, bit zero: SequenceMode_hotkey or direct
				STR		R0,[SP,#sp_add_scan_key_sequences + sp_Direct_or_Hotkey_seq]
				BNE		s_loop_seq_hotk ; is sequence hotkey mode?
				
s_loop_seq_dire	CMP		R6,#1 ; is current run of func hotkey mode?
				BEQ		s_key_not_valid
				B		s_loop_filter_conditions 
				
s_loop_seq_hotk	CMP		R6,#0 ; is current run of func direct mode?
				BEQ		s_key_not_valid

				; MOV		R0,R4
				; SUB		R0,#(ram_sequence_record_table -  ram_keypress_after_hotkey_counter) 
				LDRB	R0,[R4,#ram_keypress_after_hotkey_counter] ; [ram_basement+1] keypress-after-hotkey-counter
				CMP		R0,#0
				BEQ		s_loop_filter_conditions ; if 1st run process all sequences
				
				CMP		R1,#0 ; ram status byte of current sequence
				BEQ		s_key_not_valid 
				
				; --- filter conditions -----------------------------------------------------

s_loop_filter_conditions 
								
; input: 		; R2=sequence record address

	; DCB "*****"
					
				LDRB	R3,[R2,#seq_condition_bits] ; selected seq condition bits byte
				
				MOV		R0,#0xFC ; 0n11111100 ; mask for conditions bits 7-2
				AND		R0,R3 ; all conditions zero, just do true?
				BEQ		s_loop_filter_conditions_true_snapped
						 									
s_loop_filter_conditions_keylock	; process sequence record depending by SequenceMode_Keylock
				LDR		R0,[SP,#sp_add_scan_key_sequences+ sp_State_keylock]
				MOV		R6,#0x80 ; bit 7 keylock test yes or no
				BL		_s_loop_filter_conditions_evaluate ; returns !(test succeeded or bit 7 keylock test=no?)
				BEQ		s_loop_filter_conditions_false_not_snapped
				
s_loop_filter_conditions_scrsav	; process sequence record depending by SequenceMode_Screensaver
				LDR		R0,[SP,#sp_add_scan_key_sequences+ sp_State_screensaver]
				MOV		R6,#0x20 ; bit 5 scrsaver test yes or no
				BL		_s_loop_filter_conditions_evaluate ; returns !(test succeeded or bit 7 keylock test=no?)
				BEQ		s_loop_filter_conditions_false_not_snapped

s_loop_filter_conditions_mainscreen	; process sequence record depending by SequenceMode_GUI_State
				LDR		R0,[SP,#sp_add_scan_key_sequences+ sp_State_keylock]
				LDR		R6,[SP,#sp_add_scan_key_sequences+ sp_State_screensaver]
				BL		_get_mainscreen_state
				MOV		R6,#1
				AND		R0,R6 ; view only if "mainscreen" is on or off, dont why.
				MOV		R6,#0x8 ; bit 3 "is mainscreen or menu/list" test yes or no
				BL		_s_loop_filter_conditions_evaluate ; returns !(test succeeded or bit 7 keylock test=no?)
				BEQ		s_loop_filter_conditions_false_not_snapped
				
s_loop_filter_conditions_true_snapped
				MOV		R0,#1
				B		s_loop_filter_conditions_x	

s_loop_filter_conditions_false_not_snapped				
				MOV		R0,#0		
				
s_loop_filter_conditions_x
				; CMP		R0,#1 ; do the conditions of sequence match the state of phone?
				BEQ		s_key_not_valid
				
				; ----------------------------------------------------------------------


s_loop_filter_x	LDR		R0,[SP,#sp_add_scan_key_sequences+ sp_Direct_or_Hotkey_seq]
				CMP		R0,#1 ; is sequence direct or hotkey mode?
				BEQ		s_loop_8_hotk 

s_loop_8_direct	ADD		R0,R2,R1 ; R0=Very1stByteOfCurrSeqRec + seq rec ram counter
				B		s_loop_9
				
s_loop_8_hotk	;MOV		R0,R4
				;SUB		R0,#(ram_sequence_record_table -  ram_keypress_after_hotkey_counter)
				LDRB	R0,[R4,#ram_keypress_after_hotkey_counter] ; [ram_basement+1] keypress-after-hotkey-counter
				ADD		R0,R2,R0 ; R0=Very1stByteOfCurrSeqRec + keypress-after-hotkey-counter

s_loop_9		ADD		R0,#seq_keys ; position of first key sequence byte
				LDRB	R6,[R0] ; R0=key sequence byte of current sequence record
				
				CMP		R5,R6 ; is currently pressed key = the current key in the current sequence?
				BEQ		s_key_valid
				
				; -----------------------------------------------------------------------

s_key_not_valid	MOV		R1,#0 ; reset_sequence
				MOV		R0,#ram_sequence_record_table
				ADD		R0,R4	
				STRB	R1,[R0,R7] ; reset ram-buf for seq
				B		s_loop_return
							
s_key_valid		MOV		R6,#1
				;MOV		R3,R4
				;SUB		R3,#(ram_sequence_record_table -  ram_IsAnythingTouched)
				STRB	R6,[R4,#ram_IsAnythingTouched] ; set ram_IsAnythingTouched to true		

s_key_valid_1	LDRB	R6,[R0,#1]
				CMP		R6,#0 ; sequence end reached, cause next key sequence element 0?
				BEQ		s_action

				LDR		R3,[SP,#sp_add_scan_key_sequences+ sp_Direct_or_Hotkey_seq]
				CMP		R3,#1 ; is sequence direct or hotkey mode?
				BEQ		s_key_valid_1_hotk

s_key_valid_1_direct
				CMP		R1,#4 ; sequence end reached, cause maximum number of elements reached? (max=5. max-1=4)
				BGE		s_action
				B		s_key_in_sequence

s_key_valid_1_hotk
				;MOV		R3,R4
				;SUB		R3,#(ram_sequence_record_table -  ram_keypress_after_hotkey_counter)
				LDRB	R3,[R4,#ram_keypress_after_hotkey_counter] ; [ram_basement+1] keypress-after-hotkey-counter
				CMP		R3,#4 ; sequence end reached, cause maximum number of elements reached? (max=5. max-1=4)
				BGE		s_action
		
s_key_in_sequence
				ADD		R1,#1
				MOV		R0,R4
				ADD		R0,#ram_sequence_record_table
				STRB	R1,[R0,R7]				

s_loop_return	ADD		R7,#1 ; read next key sequence record
				B		s_loop
				
s_exit			; SUB		R4,#ram_sequence_record_table
			
				LDRB	R0,[R4,#ram_IsAnythingTouched]
				CMP		R0,#0
				BEQ 	s_exit_x

				BL		_start_seq_timeout_timer
				
s_exit_x		LDR		R1,[SP,#sp_add_scan_key_sequences+ sp_ActionPerformed]
				POP		{R0,R2-R4,R6-R7,PC}

; -----------------------------------------------------------------------------


s_action			MOV		R6,R2 ; sequence address
				
					LDRB	R7,[R6,#6] ; Sequence action type (0=sequence disengaged)
					
					STR		R6,[SP,#sp_add_scan_key_sequences+ sp_ActionPerformed] ; store anything else than FF in SequAccepted&ActionPerformed(FF=False) to dirty it. SP: ({R0-R3,R7}: 5 regs x 4 = 20 = 0x14.		
					
					
					LDR		R0,ram_mainscreen_accu_icon_
					LDR		R2,FF00
					STRH	R2,[R0] ; set to special_no_mainscreen

				
s_action_sound		LDRB	R0,[R6,#seq_sound] ; R0=sound for PlaySound ; ##########  action sound 
					LDRB	R2,[R6,#seq_soundlen] ; R2=loops for PlaySound
					ADD		R1,R0,R2
					; CMP		R1,#0
					BEQ		s_action_what
					
					BL		_playsoundloop
				

s_action_what		CMP		R7,#1 ; address launcher
					BEQ		s_action_blx
					
					CMP		R7,#2 ; device unlock 
					BEQ		s_action_dev_unlock
					
					CMP		R7,#3 ; device lock 
					BEQ		s_action_dev_lock
					
					CMP		R7,#4 ; toggle keylock
					BEQ		s_action_keylock
					
					CMP		R7,#5 ; midlet
					BEQ		s_action_midlet
					
					CMP		R7,#6 ; SetProfile
					BEQ		s_action_profile
					
					CMP		R7,#7 ; shutdown
					BEQ		s_action_shutdown
					
					B		s_exit_x
				
s_action_shutdown	LDR		R7,_ram_is_shutdown
					MOV		R1,#1
					STRB	R1,[R7]
					BL 		f009_SwitchPhoneOff
					
					MOV		R0,#3 ; turn all lights on
					BL		f068_TempLightOn
					B		s_action_x
	
s_action_keylock	LDR		R2,[SP,#sp_add_scan_key_sequences+sp_State_keylock]
					MOV		R1,#1
					SUB		R2,R1,R2
					BL		v13_RamIsLocked
					STRB	R2,[R7] ; toggle keylock
					B		s_action_x
				
s_action_dev_lock	MOV		R0,#0xFF 
					BL		_set_scrsaver ; unlock device
					B		s_action_x
				
s_action_dev_unlock	MOV		R0,#0x10
	 				BL		_set_scrsaver ; unlock device
					BL 		f031_DrawMainScreen
					B		s_action_x
				
s_action_midlet		LDRH	R0,[R6,#seq_r0] ; R0=number of midlet string
					BL		_get_keyseq_string
					MOV		R1,#1
					BL		f075_StartMidlet
					B		s_action_x
					
s_action_profile	LDRH	R0,[R6,#seq_r0] ; R0=profile number
					BL		f003_SetProfile
					B		s_action_x

s_action_blx		LDR		R0,[SP,#sp_add_scan_key_sequences+sp_State_screensaver]
					CMP		R0,#FF ; device locked 
					BEQ		_s_action_blx1
					
					MOV		R0,#0x10 ; screensaver and devicelock off
					BL		_set_scrsaver
			
_s_action_blx1		LDR		R7,[R6] ; load launch address
					LDRH	R0,[R6,#4] ; R0 for exec_address
					MOV		R1,#0
					MOV		R2,R1
					MOV		R3,R2
					BLX		R7

s_action_x	  		; send red key after action? 
					LDRB	R7,[R6,#seq_exec_bits] ; executions bits byte of sequence record
					
					MOV		R3,#2 ; test bit 1
					TST		R7,R3 
					BEQ		s_action_x_1
				
					BL		_send_redkey
					BL		_send_redkey
					
s_action_x_1		MOV		R3,#4 ; test bit 2
					TST		R7,R3
					BEQ		s_exit_x
					
					MOV		R0,#4 ; independent blinker
					LDR		R7,BlinkerEngine
					BLX		R7	
					
					B		s_exit_x	
				

; -----------------------------------------------------------------------------

_s_loop_filter_conditions_evaluate

; X=used. R0, R1X,R2X, R3, R4X,R5X,R6,R7X

; evaluates a "and" expression stored in mode byte 0 or 1, in the bits 7-6, 5-4 or 3-2
; input: 		; R0=condition content, e.g. screensaver_state. always 0 or 1.
				; R3=  mode byte content of sequence record or other
				; R6=first bit of condition, eg:0x20=bit5.
				
				TST		R6,R3 ; =0 do always.  !=0 do conditional depending on condition sex bit
				BEQ		_s_loop_filter_conditions_evaluate_true ; skip this check - return true
				
				LSR		R6,#1 ; set to condition sex bit of condition 2-bit-set
				MUL		R0,R6 ; make it up to condition sex bit
				AND		R6,R3 ; if bit=1: R6=0: do only if false. R6=1: do only if true
				CMP		R0,R6
				BEQ		_s_loop_filter_conditions_evaluate_true
				
				MOV		R0,#0
				BX		LR
					
_s_loop_filter_conditions_evaluate_true
				MOV		R0,#1
				BX		LR  ; returns ; !(test succeeded or bit 7 keylock test=no?)
			
; ========================================================================================
			
_clear_mem		PUSH	{R0,R1,R7,LR}
				LDRB	R1,[R4,#ram_SequenceRecords] ; number of key sequences 
				ADD		R1,#(ram_sequence_record_table - ram_ram_clear_please)

				MOV		R0,R4
				ADD		R0,#ram_ram_clear_please

				BL		f088_ClearMemory 
				POP		{R0,R1,R7,PC}

; ----------------------------------------------------------------------------------					
							
_send_redkey	PUSH	{R6,LR}
				MOV		R0,#0xC ; red button on
				LDR		R6,Keypress_On_Store2Ram_
				BLX		R6
				MOV		R0,#0x8C ; red button off
				LDR		R6,Keypress_Off_Store2Ram_
				BLX		R6
				POP		{R6,PC}
				
; ----------------------------------------------------------------------------------

_set_scrsaver	PUSH	{R1,R7,LR} ; input R0=state.
				MOV		R1,R0
				BL		f104_Screensaver_GetAddress
				CMP		R0,#0
				BEQ		_set_scrsaver_x
				STRB	R1,[R0]
								
_set_scrsaver_x	POP		{R1,R7,PC}

; ----------------------------------------------------------------------------------

_get_scrsaver	PUSH	{R7,LR} ; 
				BL		f104_Screensaver_GetAddress
				CMP		R0,#0
				BNE		_get_scrsaver_1
				MOV		R0,#0
				B		_get_scrsaver_x
_get_scrsaver_1	LDRB	R0,[R0]
				MOV		R7,#0x19 ; mask 00011001 for "device lock" bits
				AND		R7,R0
				CMP		R7,#0x19
				BEQ		_get_scrsaver_x
				MOV		R7,#1
				AND		R0,R7
_get_scrsaver_x	POP		{R7,PC}  ;returns R0: 0=no scrsaver, 1=scrsaver, FF=devicelock
				
; ----------------------------------------------------------------------------------
		
_get_mainscreen_state 	
; iput: R0: keylock state, R6=screensaver state
; returns in R0:
; 0 normal not mainscreen (menus, lists, midlets etc)
; 1 mainscreen (idle, keylock, screensaver, #-dialogs in keylock and screensaver)
; 2 cmd launched by keysequencer-not - at mainscreen

				PUSH	{R1-R3,LR} 
				LDR		R1,ram_mainscreen_accu_icon_
				LDRB	R3,[R1,#1] ; byte 1	
				CMP		R3,#FF 
				BNE		_get_mainscreen_state_return_true
				
_get_mainscreen_state_ff
				LDRB	R2,[R1] ; byte 0
				CMP		R2,#0 
				BNE		_get_mainscreen_state_ff_1
				
				MOV		R0,#2 ; R2=0, R3=FF: func started by key sequencer 
				B		_get_mainscreen_state_x

_get_mainscreen_state_ff_1
				CMP		R2,#FF
				BNE		_get_mainscreen_state_return_false ; !!! fall-back !!! 
				
				CMP		R6,#1 ; is screensaver?
				BEQ		_get_mainscreen_state_return_true
				
				CMP		R0,#1 ; is keylock?
				BEQ		_get_mainscreen_state_return_true

				; thist must be menu/list/progs reached normally from mainscreen

_get_mainscreen_state_return_false				
				MOV		R0,#0 
				B		_get_mainscreen_state_x	
							
_get_mainscreen_state_return_true				
				MOV		R0,#1

_get_mainscreen_state_x
				POP		{R1-R3,PC}

; -----------------------------------------------------------------------------

_playsoundloop	PUSH	{R1,R3,R7,LR}
				MOV		R1,#2
				BL		f052_PlaySoundLoop
				POP		{R1,R3,R7,PC}	

; ----------------------------------------------------------------------------------
				
;_show_message	; input: R0=LP-number OR string-address
;				PUSH	{R1,R5,R6,LR}
;				MOV		R1,R0
;				MOV		R0,#1 ; popup style
;				LDR		R6,ShowMsgInR1_4_
;				BLX		R6
;				POP		{R1,R5,R6,PC}

; ----------------------------------------------------------------------------------

_get_keyseq_string	; input: R0=string number from string database			
				MOV		R1,#0x30 ; length of string record
				MUL		R0,R1
				LDR		R1,_keyseq_strings
				ADD		R0,R1
				BX		LR ; returns in r0: address of string
				
; ----------------------------------------------------------------------------------

_start_seq_timeout_timer
				PUSH	{R0-R3,R7,LR}
				MOV		R0,#1
				STRB	R0,[R4,#ram_IsTimeoutTimerRunning]
				
				MOV		R0,R4
				ADD		R0,#ram_timer_data
				MOV		R1,#8
				LSL		R1,#8
				ADD		R1,#80
				ADR		R2,_seq_timeout
				ADD		R2,#1
				BL		f077_CallAfterTimer
				
				POP		{R0-R3,R7,PC} ; returns in r0: address of string

; ----------------------------------------------------------------------------------

 ALIGN	
_seq_timeout	PUSH	{R0-R7,LR}
				LDR		R4,patch_ram
				LDR		R4,[R4]
				LDRB	R5,[R4,#ram_IsTimeoutTimerRunning]
				
				MOV		R2,#2
				
				CMP		R5,#0
				
				BEQ		_seq_timeout_x


				MOV		R0,R4
				ADD		R0,#ram_ram_clear_please
				LDRB	R1,[R4,#ram_SequenceRecords]
				ADD		R1,#(ram_sequence_record_table - ram_hotkey_trigger)
				BL		f088_ClearMemory 

				MOV		R2,#7
				
_seq_timeout_x	MOV		R0,#0x79
				BL		_playsoundloop

				POP		{R0-R7,PC}

; ----------------------------------------------------------------------------------
				
;_error_message	PUSH	{R0,R1,LR} ; input r0: string
;				MOV		R1,R0
;				BL		_show_message
;				MOV		R0,R1
;				BL		_show_message
;				POP		{R0,R1,PC}
				
; ========================================================================================

_sequences		DCD		sequences
_keyseq_strings	DCD		keyseq_strings

 IF  FIRMWARE = 1 ; 1=m65v50
; m65v50  addresses needed by patch core 
; entrypoint: 010602D59999999910BD9999999910BDB0B5999900200831

patch_ram				DCD 0xA8000204
Keypress_On_Store2Ram_		DCD 0xA114C9D3 ; 2nd BL after Enrypoint
Keypress_Off_Store2Ram_		DCD 0xA114CA91 ; 1st BL after Enrypoint

FF00						DCD	0x0000FF00
BlinkerEngine				DCD	0xA0FDC81D


;GetProfile_				DCD	0xA08C9FE5 ; 2
;Malloc_					DCD	0xA0820F98 ; 20
;MidletExec_				DCD	0xA0C349A8 ; 75
;PlaySoundLoop_				DCD	0xA0935CF8 ; 52
;IlluminationEvent_			DCD	0xA0B69779 ; 68
;IsScreensaver				DCD	0xA163E2D1 ; 66
;ram_Keylock					DCD 0xA8655EE0

ram_mainscreen_accu_icon_	DCD 0xA863A544 ; s65v58: A868C4E4, sl65v50: A863A3D0
; A1633BF2 46 49                       LDR     R1, =ram_mainscreen_states    + 4
; (7047B0B599999999006899990028)+0xA there you find an address loaded. add 4 to address

; Screensaver_GetAddress_		DCD 0xA16310B3 ; (A0680028999901219999999910BD) + 0xE

;FunctionLibrary_ 			DCD	0xA0FC0000

;ShowMsgInR1_4_				DCD 0xA113BCEB
 
;_get_net_access_			DCD	0xA132D75D 
;(9999021C09780120914200D000207047999900787047)+0x10 you find a LDR loading the address or you can start the function.

_ram_is_shutdown			DCD	0xA86B41BC

end_of_sequences_magic		DCD	0xE0F0E0F0   

 ALIGN

;_err_nomem			DCB		"keyseq: no mem",0
;_err_noseqendtoken	DCB		"keyseq: no seq end token found",0
;_err_noseq			DCB		"keyseq: no seq in midlet found",0

mp_magic					DCD 0xB1C2D3E4
mp_id						DCD	0x0000CCC5,0,0

 ENDIF
; -----------------------------------------------------------------------------
 
 IF  FIRMWARE = 2 ; 2=sl65v50
patch_ram				DCD 0xA8000204
Keypress_On_Store2Ram_		DCD 0xA1150227
Keypress_Off_Store2Ram_		DCD 0xA11502E5 

ram_Keylock					DCD 0xA864FA8C

ram_mainscreen_accu_icon_	DCD 0xA863A3D0 

Screensaver_GetAddress_		DCD 0xA163ECC7

FunctionLibrary_ 			DCD	0xA0FC0000

;ShowMsgInR1_4_				DCD 0xA113BCEB

;_get_net_access_			DCD	0xA1339035 
_ram_is_shutdown			DCD	0xA86ADE7C


 ENDIF 
; ----------------------------------------------------------------------------------
 
 IF  FIRMWARE = 3 ; m75v13

; entry: A07FE0DA 

patch_ram					DCD 0xA8000204
Keypress_On_Store2Ram_		DCD 0xA07FDEFB
Keypress_Off_Store2Ram_		DCD 0xA07FE029 

ram_Keylock					DCD 0xA84FF840

ram_mainscreen_accu_icon_	DCD 0xA84CB48C 

Screensaver_GetAddress_		DCD 0xA02A5D85

FunctionLibrary_ 			DCD	0xA0FC0000

;ShowMsgInR1_4_				DCD 0xA113BCEB

_get_net_access_			DCD	0xA0B3F1FD

 ENDIF 
 
 IF  FIRMWARE = 4 ; s65v58
 ; 
 ENDIF
 

 END
 				



					